/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.sprites;

import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntArray;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import technology.rocketjump.undermount.assets.FloorDictionary;
import technology.rocketjump.undermount.assets.RoomEdgeTypeDictionary;
import technology.rocketjump.undermount.assets.WallQuadrantDictionary;
import technology.rocketjump.undermount.assets.WallTypeDictionary;
import technology.rocketjump.undermount.assets.model.FloorType;
import technology.rocketjump.undermount.assets.model.RoomEdgeType;
import technology.rocketjump.undermount.assets.model.WallType;
import technology.rocketjump.undermount.mapping.tile.layout.RoomTileLayout;
import technology.rocketjump.undermount.mapping.tile.layout.TileLayoutAtlas;
import technology.rocketjump.undermount.mapping.tile.layout.WallLayout;
import technology.rocketjump.undermount.sprites.model.QuadrantSprites;

public class TerrainSpriteCache {
    private final Map<Long, Map<Integer, Array<Sprite>>> wallTypeIdToWallLayoutToSpriteMap = new ConcurrentHashMap<Long, Map<Integer, Array<Sprite>>>();
    private final Map<Long, Map<Integer, Sprite>> roomEdgeTypeIdToLayoutToSpriteMap = new ConcurrentHashMap<Long, Map<Integer, Sprite>>();
    private final Map<Long, Array<Sprite>> floorTypeIdToFloorSprites = new ConcurrentHashMap<Long, Array<Sprite>>();
    private final WallQuadrantDictionary wallQuadrantDictionary;
    private final TileLayoutAtlas tileLayoutAtlas;

    @Inject
    public TerrainSpriteCache(TextureAtlas textureAtlas, WallTypeDictionary wallTypeDictionary, FloorDictionary floorDictionary, WallQuadrantDictionary wallQuadrantDictionary, TileLayoutAtlas tileLayoutAtlas, RoomEdgeTypeDictionary roomEdgeTypeDictionary) {
        ConcurrentHashMap<Integer, Object> spriteMapForMaterial;
        this.wallQuadrantDictionary = wallQuadrantDictionary;
        this.tileLayoutAtlas = tileLayoutAtlas;
        for (WallType wallType : wallTypeDictionary.getAllDefinitions()) {
            spriteMapForMaterial = new ConcurrentHashMap<Integer, Object>();
            for (Integer wallLayoutIdMatchingSprite : wallQuadrantDictionary.getUniqueQuadrantIds()) {
                Array<Sprite> wallSprites = textureAtlas.createSprites(wallType.getWallTypeName() + "_" + wallLayoutIdMatchingSprite);
                spriteMapForMaterial.put(wallLayoutIdMatchingSprite, wallSprites);
            }
            this.wallTypeIdToWallLayoutToSpriteMap.put(wallType.getWallTypeId(), spriteMapForMaterial);
        }
        for (RoomEdgeType roomEdgeType : roomEdgeTypeDictionary.getAllDefinitions()) {
            spriteMapForMaterial = new ConcurrentHashMap();
            Set<Integer> uniqueQuadrantIds = wallQuadrantDictionary.getUniqueQuadrantIds();
            for (Integer layoutIdMatchingSprite : uniqueQuadrantIds) {
                Sprite roomEdgeSprite;
                if (layoutIdMatchingSprite == 255 || (roomEdgeSprite = textureAtlas.createSprite(roomEdgeType.getRoomEdgeTypeName(), layoutIdMatchingSprite)) == null) continue;
                spriteMapForMaterial.put(layoutIdMatchingSprite, roomEdgeSprite);
            }
            this.roomEdgeTypeIdToLayoutToSpriteMap.put(roomEdgeType.getRoomEdgeTypeId(), spriteMapForMaterial);
        }
        for (FloorType floorType : floorDictionary.getAllDefinitions()) {
            this.floorTypeIdToFloorSprites.put(floorType.getFloorTypeId(), textureAtlas.createSprites(floorType.getFloorTypeName()));
        }
    }

    public QuadrantSprites getSpritesForWall(WallType wallType, WallLayout wallLayout, long seed) {
        int simplifiedLayoutId = this.tileLayoutAtlas.simplifyLayoutId(wallLayout.getId());
        IntArray wallLayoutQuadrants = this.wallQuadrantDictionary.getWallQuadrants(simplifiedLayoutId);
        return new QuadrantSprites(this.getWallSpriteForLayoutAndType(wallLayoutQuadrants.get(0), wallType, seed), this.getWallSpriteForLayoutAndType(wallLayoutQuadrants.get(1), wallType, seed), this.getWallSpriteForLayoutAndType(wallLayoutQuadrants.get(2), wallType, seed), this.getWallSpriteForLayoutAndType(wallLayoutQuadrants.get(3), wallType, seed));
    }

    public QuadrantSprites getSpritesForRoomEdge(RoomEdgeType roomEdgeType, RoomTileLayout layout) {
        int simplifiedLayoutId = this.tileLayoutAtlas.simplifyLayoutId(layout.getId());
        IntArray wallLayoutQuadrants = this.wallQuadrantDictionary.getWallQuadrants(simplifiedLayoutId);
        return new QuadrantSprites(this.getRoomEdgeSpriteForLayoutAndType(wallLayoutQuadrants.get(0), roomEdgeType), this.getRoomEdgeSpriteForLayoutAndType(wallLayoutQuadrants.get(1), roomEdgeType), this.getRoomEdgeSpriteForLayoutAndType(wallLayoutQuadrants.get(2), roomEdgeType), this.getRoomEdgeSpriteForLayoutAndType(wallLayoutQuadrants.get(3), roomEdgeType));
    }

    public Sprite getWallSpriteForLayoutAndType(int wallQuadrantLayoutId, WallType wallType, long seed) {
        Map<Integer, Array<Sprite>> layoutToSpriteMap = this.wallTypeIdToWallLayoutToSpriteMap.get(wallType.getWallTypeId());
        Array<Sprite> spritesForLayout = layoutToSpriteMap.get(wallQuadrantLayoutId);
        if (spritesForLayout.size == 1) {
            return spritesForLayout.get(0);
        }
        int spriteNum = Math.abs((int)seed) % spritesForLayout.size;
        return spritesForLayout.get(spriteNum);
    }

    public Sprite getRoomEdgeSpriteForLayoutAndType(int wallQuadrantLayoutId, RoomEdgeType roomEdgeType) {
        if (wallQuadrantLayoutId == 255) {
            return null;
        }
        Map<Integer, Sprite> layoutToSpriteMap = this.roomEdgeTypeIdToLayoutToSpriteMap.get(roomEdgeType.getRoomEdgeTypeId());
        return layoutToSpriteMap.get(wallQuadrantLayoutId);
    }

    public Sprite getFloorSpriteForType(FloorType floorType, long seed) {
        Array<Sprite> sprites = this.floorTypeIdToFloorSprites.get(floorType.getFloorTypeId());
        int spriteNum = Math.abs((int)seed) % sprites.size;
        return sprites.get(spriteNum);
    }
}

